/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.modloader;

import com.cardshifter.core.modloader.JavaMod;
import com.cardshifter.core.modloader.LoadableMod;
import com.cardshifter.core.modloader.LuaMod;
import com.cardshifter.core.modloader.Mod;
import com.cardshifter.core.modloader.ModLoader;
import com.cardshifter.core.modloader.ModLoaderHelper;
import com.cardshifter.core.modloader.ModLoadingFunction;
import com.cardshifter.core.modloader.ModNotLoadableException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;

public final class DirectoryModLoader
implements ModLoader {
    private static final Map<String, ModLoadingFunction<Path, LoadableMod, ModNotLoadableException>> LANGUAGE_MAPPING = new HashMap<String, ModLoadingFunction<Path, LoadableMod, ModNotLoadableException>>();
    private final Path modsDirectory;
    private final Map<String, LoadableMod> loadedMods = new HashMap<String, LoadableMod>();

    public DirectoryModLoader(Path modsDirectory) {
        this.modsDirectory = Objects.requireNonNull(modsDirectory, "modsDirectory");
        if (!Files.isDirectory(modsDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("modsDirectory " + modsDirectory + " must be a directory");
        }
    }

    @Override
    public Mod load(String modName) throws ModNotLoadableException {
        Objects.requireNonNull(modName, "modName");
        if (this.loadedMods.containsKey(modName)) {
            throw new ModNotLoadableException("Mod " + modName + " has already been loaded");
        }
        try {
            Path modDirectory = this.modsDirectory.resolve(modName);
            Properties properties = ModLoaderHelper.getConfiguration(modDirectory);
            String language = properties.getProperty("language");
            if (!LANGUAGE_MAPPING.containsKey(language)) {
                throw new ModNotLoadableException("Language " + language + " is not supported");
            }
            LoadableMod loadableMod = LANGUAGE_MAPPING.get(language).apply(modDirectory);
            loadableMod.load();
            this.loadedMods.put(modName, loadableMod);
            return loadableMod;
        }
        catch (Exception ex) {
            throw new ModNotLoadableException(ex);
        }
    }

    @Override
    public void unload(String modName) {
        Objects.requireNonNull(modName, "modName");
        if (!this.loadedMods.containsKey(modName)) {
            throw new IllegalArgumentException("Mod " + modName + " has not been loaded");
        }
        this.loadedMods.get(modName).unload();
        this.loadedMods.remove(modName);
    }

    @Override
    public Map<String, Mod> getLoadedMods() {
        HashMap<String, Mod> loadedModsCopy = new HashMap<String, Mod>();
        loadedModsCopy.putAll(this.loadedMods);
        return loadedModsCopy;
    }

    @Override
    public List<String> getAvailableMods() {
        try {
            return Files.list(this.modsDirectory).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).collect(Collectors.toList());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    static {
        LANGUAGE_MAPPING.put("java", JavaMod::new);
        LANGUAGE_MAPPING.put("lua", LuaMod::new);
    }
}

