/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.messages;

import com.cardshifter.api.ClientIO;
import com.cardshifter.api.messages.Message;
import com.cardshifter.core.messages.MessageHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.zomis.cardshifter.ecs.usage.CardshifterIO;

public class IncomingHandler {
    private final Map<Class<?>, MessageHandler<?>> consumer = new ConcurrentHashMap();
    private final ObjectMapper mapper = CardshifterIO.mapper();
    private final ObjectReader reader = this.mapper.reader(Message.class);

    public <E extends Message> void addHandler(String command, Class<E> handler, MessageHandler<E> consumer) {
        this.consumer.put(handler, consumer);
    }

    public <T extends Message> T parse(String json) throws IOException {
        return (T)((Message)this.reader.readValue(json));
    }

    public <E extends Message> void perform(E message, ClientIO client) {
        MessageHandler<?> messagePerform = this.consumer.get(message.getClass());
        if (messagePerform == null) {
            throw new NullPointerException("No handler for message " + message + " of class " + message.getClass());
        }
        messagePerform.handle(message, client);
    }
}

