/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.game;

import com.cardshifter.ai.FakeAIClientTCG;
import com.cardshifter.api.ClientIO;
import com.cardshifter.api.both.ChatMessage;
import com.cardshifter.api.both.PlayerConfigMessage;
import com.cardshifter.api.incoming.RequestTargetsMessage;
import com.cardshifter.api.incoming.UseAbilityMessage;
import com.cardshifter.api.messages.Message;
import com.cardshifter.api.outgoing.AvailableTargetsMessage;
import com.cardshifter.api.outgoing.CardInfoMessage;
import com.cardshifter.api.outgoing.EntityRemoveMessage;
import com.cardshifter.api.outgoing.PlayerMessage;
import com.cardshifter.api.outgoing.ResetAvailableActionsMessage;
import com.cardshifter.api.outgoing.ServerErrorMessage;
import com.cardshifter.api.outgoing.UpdateMessage;
import com.cardshifter.api.outgoing.UsableActionMessage;
import com.cardshifter.api.outgoing.ZoneChangeMessage;
import com.cardshifter.api.outgoing.ZoneMessage;
import com.cardshifter.core.game.ServerGame;
import com.cardshifter.core.replays.ReplayRecordSystem;
import com.cardshifter.modapi.actions.ActionComponent;
import com.cardshifter.modapi.actions.ActionPerformEvent;
import com.cardshifter.modapi.actions.Actions;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.actions.TargetSet;
import com.cardshifter.modapi.ai.AIComponent;
import com.cardshifter.modapi.ai.AISystem;
import com.cardshifter.modapi.ai.CardshifterAI;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ComponentRetriever;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSGameState;
import com.cardshifter.modapi.base.ECSMod;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.base.PlayerEliminatedEvent;
import com.cardshifter.modapi.cards.CardComponent;
import com.cardshifter.modapi.cards.ZoneChangeEvent;
import com.cardshifter.modapi.cards.ZoneComponent;
import com.cardshifter.modapi.events.EntityRemoveEvent;
import com.cardshifter.modapi.events.GameOverEvent;
import com.cardshifter.modapi.resources.ResourceValueChange;
import com.cardshifter.modapi.resources.Resources;
import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.zomis.cardshifter.ecs.EntitySerialization;
import net.zomis.cardshifter.ecs.config.ConfigComponent;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TCGGame
extends ServerGame {
    private static final Logger logger = LogManager.getLogger(TCGGame.class);
    private final ComponentRetriever<CardComponent> card = ComponentRetriever.retreiverFor(CardComponent.class);
    private ComponentRetriever<PlayerComponent> playerData = ComponentRetriever.retreiverFor(PlayerComponent.class);
    private final ECSMod mod;
    private final Supplier<ScheduledExecutorService> aiExecutor;
    private final String modName;

    public TCGGame(Supplier<ScheduledExecutorService> aiExecutor, String name, int id, ECSMod mod) {
        super(id, new ECSGame());
        this.modName = name;
        this.aiExecutor = aiExecutor;
        this.mod = mod;
    }

    private void zoneChange(ZoneChangeEvent event) {
        Entity cardEntity = event.getCard();
        int source = -1;
        if (event.getSource() != null) {
            source = event.getSource().getZoneId();
        }
        for (ClientIO io : this.getPlayers()) {
            Entity player = this.playerFor(io);
            boolean sourceKnown = false;
            if (event.getSource() != null) {
                sourceKnown = event.getSource().isKnownTo(player);
            }
            io.sendToClient((Message)new ZoneChangeMessage(event.getCard().getId(), source, event.getDestination().getZoneId()));
            if (!event.getDestination().isKnownTo(player) || sourceKnown) continue;
            this.sendRealCardData(io, event.getDestination().getZoneId(), cardEntity);
        }
    }

    private void sendRealCardData(ClientIO io, int zoneId, Entity cardEntity) {
        io.sendToClient((Message)new CardInfoMessage(zoneId, cardEntity.getId(), this.infoMap(cardEntity)));
    }

    private void remove(EntityRemoveEvent event) {
        this.send((Message)new EntityRemoveMessage(event.getEntity().getId()));
    }

    private void broadcast(ResourceValueChange event) {
        if (this.game.getGameState() == ECSGameState.NOT_STARTED) {
            return;
        }
        Entity entity = event.getEntity();
        UpdateMessage updateEvent = new UpdateMessage(entity.getId(), (Object)event.getResource().toString(), (Object)event.getNewValue());
        if (this.card.has(entity)) {
            CardComponent cardData = (CardComponent)this.card.get(entity);
            for (ClientIO io : this.getPlayers()) {
                Entity player = this.playerFor(io);
                if (!cardData.getCurrentZone().isKnownTo(player)) continue;
                io.sendToClient((Message)updateEvent);
            }
        } else {
            this.send((Message)updateEvent);
        }
    }

    public void informAboutTargets(RequestTargetsMessage message, ClientIO client) {
        ECSAction action = this.findAction(message.getId(), message.getAction());
        TargetSet targetAction = (TargetSet)action.getTargetSets().get(0);
        List targets = targetAction.findPossibleTargets();
        int[] targetIds = targets.stream().mapToInt(e -> e.getId()).toArray();
        client.sendToClient((Message)new AvailableTargetsMessage(message.getId(), message.getAction(), targetIds, targetAction.getMin(), targetAction.getMax()));
    }

    public ECSAction findAction(int entityId, String actionId) {
        Entity entity = Objects.requireNonNull(this.game.getEntity(entityId), "Entity " + entityId + " not found");
        ECSAction action = Actions.getAction((Entity)entity, (String)actionId);
        return Objects.requireNonNull(action, "Action " + actionId + " not found on entity " + entityId);
    }

    public void handleMove(UseAbilityMessage message, ClientIO client) {
        boolean allowed;
        if (this.isGameOver()) {
            logger.info((Object)("Ignoring move because game has ended: " + message + " from " + client));
            return;
        }
        if (!this.getPlayers().contains(client)) {
            throw new IllegalArgumentException("Client is not in this game: " + client);
        }
        ECSAction action = this.findAction(message.getId(), message.getAction());
        if (!action.getTargetSets().isEmpty()) {
            TargetSet targetAction = (TargetSet)action.getTargetSets().get(0);
            targetAction.clearTargets();
            for (int target : message.getTargets()) {
                targetAction.addTarget(this.game.getEntity(target));
            }
        }
        if (!(allowed = action.perform(this.playerFor(client)))) {
            client.sendToClient((Message)new ServerErrorMessage("Action not allowed: " + action));
        }
        this.sendAvailableActions();
    }

    public Entity playerFor(ClientIO io) {
        int index = this.getPlayers().indexOf(io);
        if (index < 0) {
            throw new IllegalArgumentException(io + " is not a valid player in this game");
        }
        return this.getPlayer(index);
    }

    private Entity getPlayer(int index) {
        List players = this.game.findEntities(entity -> entity.hasComponent(PlayerComponent.class) && ((PlayerComponent)entity.getComponent(PlayerComponent.class)).getIndex() == index);
        if (players.size() != 1) {
            throw new IllegalStateException("Found " + players.size() + " results for entities with Player index " + index);
        }
        return (Entity)players.get(0);
    }

    @Override
    protected void onStart() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss").withZone(ZoneId.systemDefault());
        String time = formatter.format(Instant.now());
        File directory = new File("replays", this.modName);
        directory.mkdirs();
        this.game.addSystem((ECSSystem)new ReplayRecordSystem(this.game, this.modName, new File(directory, "replay-" + this.getId() + "-" + time + ".json")));
        if (!this.preStartForConfiguration()) {
            this.startECSGame();
            this.setupAIPlayers();
            AISystem.call((ECSGame)this.game);
        }
    }

    public boolean preStartForConfiguration() {
        this.mod.declareConfiguration(this.game);
        if (this.isConfigNeeded()) {
            this.setupAIPlayers();
            this.requestPlayerConfig();
            return true;
        }
        return false;
    }

    private void playerEliminated(PlayerEliminatedEvent event) {
        String winStatus = event.isDeclaredWinner() ? "won" : "lost";
        PlayerComponent player = (PlayerComponent)event.getEntity().getComponent(PlayerComponent.class);
        this.sendChat(player.getName() + " " + winStatus + " game " + this.getId());
    }

    public void sendChat(String message) {
        this.send((Message)new ChatMessage(0, "Server", message));
    }

    private void startECSGame() {
        this.mod.setupGame(this.game);
        this.game.getEvents().registerHandlerAfter((Object)this, ResourceValueChange.class, this::broadcast);
        this.game.getEvents().registerHandlerAfter((Object)this, ZoneChangeEvent.class, this::zoneChange);
        this.game.getEvents().registerHandlerAfter((Object)this, EntityRemoveEvent.class, this::remove);
        this.game.getEvents().registerHandlerAfter((Object)this, PlayerEliminatedEvent.class, this::playerEliminated);
        this.game.getEvents().registerHandlerAfter((Object)this, GameOverEvent.class, event -> this.endGame());
        AISystem.setup((ECSGame)this.game, (ScheduledExecutorService)this.aiExecutor.get());
        this.game.addSystem(game -> game.getEvents().registerHandlerAfter((Object)this, ActionPerformEvent.class, event -> this.sendAvailableActions()));
        this.game.startGame();
        this.getPlayers().stream().forEach(pl -> {
            Entity playerEntity = this.playerFor((ClientIO)pl);
            PlayerComponent plData = (PlayerComponent)playerEntity.get(this.playerData);
            plData.setName(pl.getName());
            this.send((Message)new PlayerMessage(playerEntity.getId(), plData.getIndex(), plData.getName(), Resources.map((Entity)playerEntity)));
        });
        this.game.findEntities(e -> true).stream().flatMap(e -> e.getSuperComponents(ZoneComponent.class).stream()).forEach(this::sendZone);
        this.sendAvailableActions();
    }

    private boolean requestPlayerConfig() {
        Set configEntities = this.game.getEntitiesWithComponent(ConfigComponent.class);
        boolean sent = false;
        for (ClientIO io : this.getPlayers()) {
            Entity playerEntity = this.playerFor(io);
            if (!configEntities.contains(playerEntity)) continue;
            PlayerConfigMessage configMessage = new PlayerConfigMessage(this.getId(), this.modName, ((ConfigComponent)playerEntity.getComponent(ConfigComponent.class)).getConfigs());
            io.sendToClient((Message)configMessage);
            if (io instanceof FakeAIClientTCG) {
                FakeAIClientTCG aiClient = (FakeAIClientTCG)io;
                CardshifterAI ai = aiClient.getAI();
                ai.configure(playerEntity, (ConfigComponent)playerEntity.getComponent(ConfigComponent.class));
                ((ConfigComponent)playerEntity.getComponent(ConfigComponent.class)).setConfigured(true);
                continue;
            }
            sent = true;
        }
        return sent;
    }

    private void setupAIPlayers() {
        for (ClientIO io : this.getPlayers()) {
            if (!(io instanceof FakeAIClientTCG)) continue;
            FakeAIClientTCG aiClient = (FakeAIClientTCG)io;
            Entity player = this.playerFor(io);
            AIComponent aiComponent = new AIComponent(aiClient.getAI());
            aiComponent.setDelay(2000L);
            player.addComponent((Component)aiComponent);
            logger.info((Object)("AI is configured for " + player));
        }
    }

    private void sendAvailableActions() {
        for (ClientIO io : this.getPlayers()) {
            io.sendToClient((Message)new ResetAvailableActionsMessage());
            if (this.game.isGameOver()) continue;
            Entity player = this.playerFor(io);
            TCGGame.getAllActions(this.game).filter(action -> action.isAllowed(player)).forEach(action -> io.sendToClient((Message)new UsableActionMessage(action.getOwner().getId(), action.getName(), !action.getTargetSets().isEmpty())));
        }
    }

    private static Stream<ECSAction> getAllActions(ECSGame game) {
        return game.getEntitiesWithComponent(ActionComponent.class).stream().flatMap(entity -> ((ActionComponent)entity.getComponent(ActionComponent.class)).getECSActions().stream());
    }

    private void sendZone(ZoneComponent zone) {
        for (ClientIO io : this.getPlayers()) {
            Entity player = this.playerFor(io);
            io.sendToClient((Message)this.constructZoneMessage(zone, player));
            if (!zone.isKnownTo(player)) continue;
            zone.forEach(card -> this.sendCard(io, (Entity)card));
        }
    }

    private ZoneMessage constructZoneMessage(ZoneComponent zone, Entity player) {
        return new ZoneMessage(zone.getZoneId(), zone.getName(), zone.getOwner().getId(), zone.size(), zone.isKnownTo(player), zone.stream().mapToInt(e -> e.getId()).toArray());
    }

    private void sendCard(ClientIO io, Entity card) {
        CardComponent cardData = (CardComponent)card.getComponent(CardComponent.class);
        io.sendToClient((Message)new CardInfoMessage(cardData.getCurrentZone().getZoneId(), card.getId(), this.infoMap(card)));
    }

    private Map<String, Object> infoMap(Entity entity) {
        return EntitySerialization.serialize((Entity)entity);
    }

    public void incomingPlayerConfig(PlayerConfigMessage message, ClientIO client) {
        Entity player = this.playerFor(client);
        ConfigComponent config = (ConfigComponent)player.getComponent(ConfigComponent.class);
        for (Map.Entry entry : message.getConfigs().entrySet()) {
            config.addConfig((String)entry.getKey(), entry.getValue());
            logger.info((Object)("Incoming player config for " + player + ": " + entry.getValue()));
        }
        config.setConfigured(true);
        this.checkStartGame();
    }

    public void checkStartGame() {
        if (!this.isConfigNeeded()) {
            this.startECSGame();
        }
    }

    public boolean isConfigNeeded() {
        Set configEntities = this.game.getEntitiesWithComponent(ConfigComponent.class);
        return configEntities.stream().map(e -> (ConfigComponent)e.getComponent(ConfigComponent.class)).anyMatch(config -> !config.isConfigured());
    }
}

