/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.game;

import com.cardshifter.api.ClientIO;
import com.cardshifter.api.messages.Message;
import com.cardshifter.api.outgoing.GameOverMessage;
import com.cardshifter.api.outgoing.NewGameMessage;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSGameState;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class ServerGame {
    private static final Logger logger = LogManager.getLogger(ServerGame.class);
    private final List<ClientIO> players;
    private final int id;
    private Instant active;
    protected final ECSGame game;

    public ServerGame(int id, ECSGame game) {
        this.id = id;
        this.players = Collections.synchronizedList(new ArrayList());
        this.active = Instant.now();
        this.game = game;
    }

    public void endGame() {
        logger.info((Object)("Game Ended: " + this + " with players " + this.players));
        this.send((Message)new GameOverMessage());
        this.active = Instant.now();
    }

    public boolean isGameOver() {
        return this.game.isGameOver();
    }

    public void start(List<ClientIO> players) {
        if (this.game.getGameState() != ECSGameState.NOT_STARTED) {
            throw new IllegalStateException("Game can only be started once");
        }
        players.forEach(this::addPlayer);
        for (ClientIO player : players) {
            player.sendToClient((Message)new NewGameMessage(this.id, players.indexOf(player)));
        }
        this.onStart();
        this.active = Instant.now();
    }

    protected abstract void onStart();

    public void send(Message data) {
        this.players.forEach(player -> player.sendToClient(data));
    }

    public int getId() {
        return this.id;
    }

    public Duration getLastActive() {
        return Duration.between(this.active, Instant.now());
    }

    public ECSGameState getState() {
        return this.game.getGameState();
    }

    public ECSGame getGameModel() {
        return this.game;
    }

    public List<ClientIO> getPlayers() {
        return Collections.unmodifiableList(this.players);
    }

    public boolean hasPlayer(ClientIO client) {
        return this.players.contains(client);
    }

    public void addPlayer(ClientIO client) {
        this.players.add(client);
    }
}

