/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.game;

import com.cardshifter.ai.AIs;
import com.cardshifter.ai.ScoringAI;
import com.cardshifter.core.modloader.DirectoryModLoader;
import com.cardshifter.core.modloader.JavaScriptMod;
import com.cardshifter.core.modloader.Mod;
import com.cardshifter.core.modloader.ModNotLoadableException;
import com.cardshifter.modapi.ai.CardshifterAI;
import com.cardshifter.modapi.base.ECSMod;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.script.ScriptEngineManager;
import net.zomis.cardshifter.ecs.usage.PhrancisGameNewAttackSystem;
import net.zomis.cardshifter.ecs.usage.PhrancisGameWithSpells;
import net.zomis.cardshifter.ecs.usage.TestMod;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ModCollection {
    private static final Logger logger = LogManager.getLogger(ModCollection.class);
    private final Map<String, CardshifterAI> ais = new LinkedHashMap<String, CardshifterAI>();
    private final Map<String, Supplier<ECSMod>> mods = new HashMap<String, Supplier<ECSMod>>();

    public ModCollection() {
        this.ais.put("Loser", new ScoringAI(AIs.loser()));
        this.ais.put("Idiot", new ScoringAI(AIs.idiot()));
        this.ais.put("Medium", new ScoringAI(AIs.medium(), AIs::mediumDeck));
        this.ais.put("Fighter", new ScoringAI(AIs.fighter(), AIs::fighterDeck));
        ScriptEngineManager scripts = new ScriptEngineManager();
        this.mods.put("NewJS", () -> new JavaScriptMod("JSGame.js", scripts));
        this.mods.put("Cyborg-Chronicles", () -> new PhrancisGameNewAttackSystem());
        this.mods.put("Cyborg-Spells", () -> new PhrancisGameWithSpells());
        this.mods.put("Test", () -> new TestMod());
    }

    public void loadExternal(Path directory) {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            logger.warn((Object)(directory + " not found. No external mods loaded"));
            return;
        }
        DirectoryModLoader loader = new DirectoryModLoader(directory);
        List<String> loadableMods = loader.getAvailableMods();
        for (String modName : loadableMods) {
            this.mods.put(modName, () -> {
                try {
                    Mod mod = loader.load(modName);
                    return mod;
                }
                catch (ModNotLoadableException e) {
                    logger.warn((Object)("Unable to load mod " + modName), (Throwable)e);
                    return null;
                }
            });
        }
    }

    public Map<String, CardshifterAI> getAIs() {
        return Collections.unmodifiableMap(this.ais);
    }

    public Set<String> getAvailableMods() {
        return Collections.unmodifiableSet(this.mods.keySet());
    }

    public ECSMod getModFor(String name) {
        Supplier<ECSMod> supplier = this.mods.get(name);
        return supplier == null ? null : supplier.get();
    }

    public Path getDefaultModLocation() {
        return new File(System.getProperty("user.home"), "cardshifter-mods").toPath();
    }
}

