/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.cardloader;

import com.cardshifter.core.cardloader.CardLoader;
import com.cardshifter.core.cardloader.CardLoaderHelper;
import com.cardshifter.core.cardloader.CardLoadingException;
import com.cardshifter.core.cardloader.UncheckedCardLoadingException;
import com.cardshifter.modapi.attributes.ECSAttribute;
import com.cardshifter.modapi.attributes.ECSAttributeMap;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSMod;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.cards.IdComponent;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceMap;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlCardLoader
implements CardLoader<Path> {
    @Override
    public Collection<Entity> loadCards(Path path, ECSGame game, ECSMod mod, ECSResource[] resources, ECSAttribute[] attributes) throws CardLoadingException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(game, "game");
        Objects.requireNonNull(mod, "mod");
        List<ECSResource> resourcesList = resources == null ? Arrays.asList(new ECSResource[0]) : Arrays.asList(resources);
        List<ECSAttribute> attributesList = attributes == null ? Arrays.asList(new ECSAttribute[0]) : Arrays.asList(attributes);
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = saxBuilder.build(path.toFile());
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getCompactFormat().setExpandEmptyElements(true));
            String unformattedXmlString = xmlOutputter.outputString(document);
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            XmlMapper xmlMapper = new XmlMapper(xmlModule);
            CardInfo cardInfo = (CardInfo)xmlMapper.readValue(unformattedXmlString, CardInfo.class);
            List tags = Stream.concat(resourcesList.stream(), attributesList.stream()).map(ecsElement -> CardLoaderHelper.sanitizeTag(ecsElement.toString())).collect(Collectors.toList());
            if (CardLoaderHelper.requiredTags().stream().anyMatch(tags::contains)) {
                throw new UncheckedCardLoadingException("Tags " + CardLoaderHelper.requiredTags() + " are required by default, you cannot submit them in the resource or attribute fields.");
            }
            List duplicateTags = tags.stream().collect(Collectors.groupingBy(i -> i)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            if (!duplicateTags.isEmpty()) {
                throw new UncheckedCardLoadingException("Tags " + duplicateTags + " have been input multiple times, this is not allowed.");
            }
            Map<String, ECSResource> ecsResourcesMap = resourcesList.stream().collect(Collectors.toMap(ecsResource -> CardLoaderHelper.sanitizeTag(ecsResource.toString()), i -> i));
            Map<String, ECSAttribute> ecsAttributesMap = attributesList.stream().collect(Collectors.toMap(ecsAttribute -> CardLoaderHelper.sanitizeTag(ecsAttribute.toString()), i -> i));
            List<Card> cardList = cardInfo.getCards().getCards();
            List duplicateIds = cardList.stream().collect(Collectors.groupingBy(Card::getId)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            if (!duplicateIds.isEmpty()) {
                throw new UncheckedCardLoadingException("Card ids " + duplicateIds + " are duplicates, this is not allowed.");
            }
            return cardList.stream().map(card -> {
                Entity entity = game.newEntity();
                entity.addComponent((Component)new IdComponent(card.getId()));
                ECSResourceMap resourceMap = ECSResourceMap.createFor((Entity)entity);
                ECSAttributeMap attributeMap = ECSAttributeMap.createFor((Entity)entity);
                card.getElements().forEach((sanitizedTag, value) -> {
                    if (ecsResourcesMap.containsKey(sanitizedTag)) {
                        resourceMap.set((ECSResource)ecsResourcesMap.get(sanitizedTag), Integer.parseInt(value.toString()));
                    } else if (ecsAttributesMap.containsKey(sanitizedTag)) {
                        attributeMap.set((ECSAttribute)ecsAttributesMap.get(sanitizedTag), value.toString());
                    } else {
                        throw new UncheckedCardLoadingException("Element " + sanitizedTag + " has not been found in the supplied resource and attribute mappings where card id = " + card.getId());
                    }
                });
                return entity;
            }).collect(Collectors.toList());
        }
        catch (UncheckedCardLoadingException ex) {
            throw new CardLoadingException(ex.getMessage(), ex.getCause());
        }
        catch (Exception ex) {
            throw new CardLoadingException(ex);
        }
    }

    private static class Card {
        private String id;
        private boolean duplicateId = false;
        private final Map<String, Object> elements = new HashMap<String, Object>();
        private boolean duplicateElements = false;
        private final List<String> duplicateElementTags = new ArrayList<String>();

        private Card() {
        }

        @JsonAnySetter
        private void addElement(String tag, Object value) {
            String sanitizedTag;
            switch (sanitizedTag = CardLoaderHelper.sanitizeTag(tag)) {
                case "id": {
                    if (this.id != null) {
                        this.duplicateId = true;
                        return;
                    }
                    this.id = value.toString();
                    break;
                }
                default: {
                    if (this.elements.containsKey(sanitizedTag)) {
                        this.duplicateElements = true;
                        this.duplicateElementTags.add(sanitizedTag);
                        return;
                    }
                    this.elements.put(sanitizedTag, value);
                }
            }
        }

        public String getId() {
            if (this.duplicateId) {
                throw new UncheckedCardLoadingException("Element id has duplicate entries");
            }
            if (this.id == null) {
                throw new UncheckedCardLoadingException("Required element id has not been set");
            }
            return this.id;
        }

        @JsonAnyGetter
        public Map<String, Object> getElements() {
            if (this.duplicateElements) {
                throw new UncheckedCardLoadingException("Elements " + this.duplicateElementTags + " have duplicate entries where card id = " + this.id);
            }
            return new HashMap<String, Object>(this.elements);
        }
    }

    private static class Cards {
        @JacksonXmlProperty(localName="Card")
        private Card[] cards;

        private Cards() {
        }

        public List<Card> getCards() {
            if (this.cards == null) {
                this.cards = new Card[0];
            }
            return Arrays.asList(this.cards);
        }
    }

    private static class CardInfo {
        @JacksonXmlProperty(localName="Cards")
        private Cards cards;

        private CardInfo() {
        }

        public Cards getCards() {
            if (this.cards == null) {
                this.cards = new Cards();
            }
            return this.cards;
        }
    }
}

