/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.cardloader;

import com.cardshifter.core.cardloader.CardLoader;
import com.cardshifter.core.cardloader.CardLoaderHelper;
import com.cardshifter.core.cardloader.CardLoadingException;
import com.cardshifter.modapi.attributes.ECSAttribute;
import com.cardshifter.modapi.attributes.ECSAttributeMap;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSMod;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceMap;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SimpleCardLoader
implements CardLoader<Path> {
    private static final Pattern property = Pattern.compile("^(\\w+)=(.+)$");
    private static final Pattern apply = Pattern.compile("^apply\\:(\\w+)\\:?(.+)?$");
    private static final Logger logger = LogManager.getLogger(SimpleCardLoader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<Entity> loadCards(Path input, ECSGame game, ECSMod mod, ECSResource[] resources, ECSAttribute[] attributes) throws CardLoadingException {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(input.toFile()), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new CardLoadingException("Cannot find file " + input, e);
        }
        try (BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            ArrayList<Entity> entities = new ArrayList<Entity>();
            Entity entity = null;
            while ((line = reader.readLine()) != null) {
                Matcher propertyMatcher;
                if (line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    entity = game.newEntity();
                    logger.info((Object)("New entity: " + entity));
                    entities.add(entity);
                    continue;
                }
                Matcher applyMatcher = apply.matcher(line);
                if (applyMatcher.find()) {
                    logger.info((Object)("Applying " + line));
                    String methodName = applyMatcher.group(1);
                    String parameters = applyMatcher.group(2);
                    this.applyApply(entity, mod, methodName, parameters);
                }
                if (!(propertyMatcher = property.matcher(line)).find()) continue;
                logger.info((Object)("Property " + line));
                String propertyName = propertyMatcher.group(1);
                String propertyValue = propertyMatcher.group(2);
                this.applyProperty(entity, resources, attributes, propertyName, propertyValue);
            }
            ArrayList<Entity> arrayList = entities;
            return arrayList;
        }
        catch (IOException e) {
            throw new CardLoadingException(e);
        }
    }

    private void applyApply(Entity entity, ECSMod mod, String methodName, String parameters) throws CardLoadingException {
        if (parameters == null) {
            Consumer<Entity> field = this.findConsumerField(mod, methodName);
            field.accept(entity);
        } else {
            Consumer<Entity> consumer = this.findConsumerMethod(mod, methodName, parameters);
            consumer.accept(entity);
        }
    }

    private Consumer<Entity> findConsumerMethod(ECSMod mod, String methodName, String parameters) throws CardLoadingException {
        Class<?> clazz = mod.getClass();
        ArrayList result = new ArrayList();
        do {
            result.addAll(Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(methodName)).collect(Collectors.toList()));
        } while ((clazz = clazz.getSuperclass()) != null);
        if (result.size() != 1) {
            throw new CardLoadingException("Not a unique method: " + methodName + " in " + mod + " found " + result.size() + " results.");
        }
        Method method2 = (Method)result.get(0);
        List<Object> callParams = this.transformParameters(parameters, method2.getParameterTypes());
        try {
            method2.setAccessible(true);
            return (Consumer)method2.invoke((Object)mod, callParams.toArray());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CardLoadingException(e);
        }
    }

    private List<Object> transformParameters(String parameters, Class<?>[] parameterTypes) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (parameters.length() > 0) {
            int nextComma;
            if (parameters.startsWith("\"")) {
                parameters = parameters.substring(1);
                int endIndex = parameters.indexOf(34);
                result.add(parameters.substring(0, endIndex));
                parameters = parameters.substring(endIndex + 1);
            } else {
                nextComma = parameters.indexOf(44);
                if (nextComma == -1) {
                    nextComma = parameters.length();
                }
                result.add(Integer.parseInt(parameters.substring(0, nextComma)));
            }
            nextComma = parameters.indexOf(44);
            if (nextComma == -1) break;
            parameters = parameters.substring(nextComma + 1);
        }
        return result;
    }

    private Consumer<Entity> findConsumerField(ECSMod mod, String methodName) throws CardLoadingException {
        Optional<Field> result;
        Class<?> clazz = mod.getClass();
        do {
            result = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getName().equals(methodName)).findAny();
            clazz = clazz.getSuperclass();
        } while (!result.isPresent() && clazz != null);
        if (result.isPresent()) {
            try {
                Field field2 = result.get();
                field2.setAccessible(true);
                return (Consumer)field2.get(mod);
            }
            catch (IllegalAccessException e) {
                throw new CardLoadingException(e);
            }
        }
        throw new CardLoadingException("Field not found: " + methodName + " in " + mod);
    }

    private void applyProperty(Entity entity, ECSResource[] resources, ECSAttribute[] attributes, String propertyName, String propertyValue) throws CardLoadingException {
        ECSAttributeMap resMap;
        String cleanedName = CardLoaderHelper.sanitizeTag(propertyName);
        Optional<ECSResource> matchingResource = Arrays.stream(resources).filter(res -> CardLoaderHelper.sanitizeTag(res.toString()).equals(cleanedName)).findAny();
        Optional<ECSAttribute> matchingAttribute = Arrays.stream(attributes).filter(res -> CardLoaderHelper.sanitizeTag(res.toString()).equals(cleanedName)).findAny();
        if (matchingAttribute.isPresent()) {
            resMap = ECSAttributeMap.createOrGetFor((Entity)entity);
            resMap.set(matchingAttribute.get(), propertyValue);
        }
        if (matchingResource.isPresent()) {
            resMap = ECSResourceMap.createOrGetFor((Entity)entity);
            try {
                resMap.set(matchingResource.get(), Integer.parseInt(propertyValue));
            }
            catch (NumberFormatException ex) {
                throw new CardLoadingException("Cannot set resource " + propertyName + " to " + propertyValue, ex);
            }
        }
        if (!matchingAttribute.isPresent() && !matchingResource.isPresent()) {
            throw new CardLoadingException("Cannot set " + propertyName + " to " + propertyValue + ": No such attribute or property");
        }
    }
}

