/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core;

import com.cardshifter.core.Events;
import com.cardshifter.core.ExtLuaTable;
import com.cardshifter.core.IdEntity;
import com.cardshifter.core.Player;
import com.cardshifter.core.Zone;
import com.cardshifter.core.actions.UsableAction;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

@Deprecated
public class Game
implements IdEntity {
    @SuppressWarnings
    public final LuaValue data = new ExtLuaTable((key, value) -> this.broadcastChange(this, key, value));
    private final List<Zone> zones = new ArrayList<Zone>();
    private final List<Player> players = new ArrayList<Player>();
    private final Events events;
    private final Random random;
    private boolean gameOver = false;
    private final AtomicInteger ids;
    private int turnNumber;
    private Player currentPlayer;
    private final StateChangeListener listener;
    private final int id;

    public Game(InputStream file, Random random) {
        this(file, random, null);
    }

    public Game(InputStream file, Random random, StateChangeListener listener) {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(random, "random");
        this.ids = new AtomicInteger(0);
        this.id = this.nextId();
        this.events = new Events(file);
        this.random = random;
        this.players.add(new Player(this, "Player1", this.nextId()));
        this.players.add(new Player(this, "Player2", this.nextId()));
        this.listener = listener;
        this.turnNumber = 1;
    }

    public Game(InputStream file) {
        this(file, new Random());
    }

    public int getTurnNumber() {
        return this.turnNumber;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public List<Zone> getZones() {
        return this.zones;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public Player getFirstPlayer() {
        return this.players.get(0);
    }

    public Player getPlayer(int index) {
        return this.players.get(index);
    }

    public Player getLastPlayer() {
        return this.players.get(this.players.size() - 1);
    }

    public Events getEvents() {
        return this.events;
    }

    public Zone createZone(Player owner, String name) {
        Zone zone = new Zone(owner, name, this.nextId());
        this.zones.add(zone);
        return zone;
    }

    public List<UsableAction> getAllActions() {
        Stream playerActions = this.getPlayers().stream().flatMap(player -> player.getActions().values().stream());
        Stream cardActions = this.getZones().stream().flatMap(zone -> zone.getCards().stream()).flatMap(card -> card.getActions().values().stream());
        return Stream.concat(playerActions, cardActions).collect(Collectors.toList());
    }

    public void on(String eventName, LuaFunction function) {
        this.events.registerListener(eventName, (LuaValue)function);
    }

    public void nextTurn() {
        if (this.currentPlayer != null) {
            this.events.callEvent("turnEnd", CoerceJavaToLua.coerce((Object)this.currentPlayer), null);
        }
        this.currentPlayer = this.currentPlayer == null ? this.players.get(0) : this.currentPlayer.getNextPlayer();
        this.events.callEvent("turnStart", CoerceJavaToLua.coerce((Object)this.currentPlayer), null);
        if (this.currentPlayer == this.getLastPlayer()) {
            ++this.turnNumber;
        }
    }

    public int randomInt(int count) {
        return this.random.nextInt(count);
    }

    public Random getRandom() {
        return this.random;
    }

    public void setCurrentPlayer(Player currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public void gameOver() {
        this.gameOver = true;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    int nextId() {
        return this.ids.getAndIncrement();
    }

    void broadcastChange(IdEntity what, Object key, Object value) {
        if (this.listener != null) {
            this.listener.onChange(what, key, value);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public static interface StateChangeListener {
        public void onChange(IdEntity var1, Object var2, Object var3);
    }
}

