/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core;

import com.cardshifter.core.ExtLuaTable;
import com.cardshifter.core.Game;
import com.cardshifter.core.IdEntity;
import com.cardshifter.core.Player;
import com.cardshifter.core.Targetable;
import com.cardshifter.core.Zone;
import com.cardshifter.core.actions.CardAction;
import com.cardshifter.core.actions.TargetAction;
import com.cardshifter.core.actions.UsableAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@Deprecated
public class Card
implements Targetable,
IdEntity {
    public final LuaTable data = new ExtLuaTable(this::onChange);
    private final Map<String, UsableAction> actions = new HashMap<String, UsableAction>();
    private Optional<Zone> currentZone;
    private final Game game;
    private final int id;

    Card(Zone currentZone, int id) {
        this.id = id;
        this.currentZone = Optional.of(currentZone);
        this.game = currentZone.getGame();
    }

    private void onChange(Object key, Object value) {
        System.out.println(this + ": " + key + " = " + value);
        this.getGame().broadcastChange(this, key, value);
    }

    public Zone getZone() {
        return this.currentZone.get();
    }

    public boolean hasZone() {
        return this.currentZone.isPresent();
    }

    public CardAction addAction(String name, LuaValue actionAllowed, LuaValue actionPerformed) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(actionAllowed, "actionAllowed");
        Objects.requireNonNull(actionPerformed, "actionPerformed");
        CardAction action = new CardAction(this, name, actionAllowed, actionPerformed);
        this.actions.put(name, action);
        return action;
    }

    public TargetAction addTargetAction(String name, LuaValue actionAllowed, LuaValue targetAllowed, LuaValue actionPerformed) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(actionAllowed, "actionAllowed");
        Objects.requireNonNull(actionPerformed, "actionPerformed");
        TargetAction action = new TargetAction(this, name, actionAllowed, targetAllowed, actionPerformed);
        this.actions.put(name, action);
        return action;
    }

    public Player getOwner() {
        if (!this.currentZone.isPresent()) {
            throw new IllegalStateException("Card is not inside a zone: " + this);
        }
        return this.currentZone.get().getOwner();
    }

    public Map<String, UsableAction> getActions() {
        return this.actions;
    }

    public UsableAction getAction(String name) {
        return this.actions.get(Objects.requireNonNull(name, "name"));
    }

    public void destroy() {
        this.setZoneInternal(null);
    }

    public void moveToTopOf(Zone destination) {
        this.moveToZoneInternal(Objects.requireNonNull(destination, "destination"), true);
    }

    public void moveToBottomOf(Zone destination) {
        this.moveToZoneInternal(Objects.requireNonNull(destination, "destination"), false);
    }

    private void moveToZoneInternal(Zone destination, boolean top) {
        this.setZone(destination, zone -> {
            Consumer<Card> consumer = top ? zone.getCards()::addFirst : zone.getCards()::addLast;
            consumer.accept(this);
        });
    }

    private void setZoneInternal(Zone destination) {
        this.setZone(destination, zone -> {});
    }

    private void setZone(Zone destination, Consumer<Zone> zoneConsumer) {
        Objects.requireNonNull(zoneConsumer, "zoneConsumer");
        Zone resultDestination = this.currentZone.get().getGame().getEvents().zoneMove(this, this.currentZone.get(), destination);
        this.currentZone.get().getCards().remove(this);
        zoneConsumer.accept(destination);
        this.currentZone = Optional.ofNullable(resultDestination);
    }

    public Game getGame() {
        return this.game;
    }

    @Override
    public LuaTable getData() {
        return this.data;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String toString() {
        return String.format("{Card id %d in zone %s}", this.getId(), this.hasZone() ? this.getZone() : "/dev/null");
    }
}

