/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.ai.phrancis;

import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.actions.TargetSet;
import com.cardshifter.modapi.base.ComponentRetriever;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.base.Retrievers;
import com.cardshifter.modapi.cards.BattlefieldComponent;
import com.cardshifter.modapi.cards.CardComponent;
import com.cardshifter.modapi.cards.HandComponent;
import com.cardshifter.modapi.cards.ZoneComponent;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.zomis.aiscores.ScoreParameters;
import net.zomis.cardshifter.ecs.usage.PhrancisGame;

public class AttackAnalyze {
    private static final ResourceRetriever health = ResourceRetriever.forResource((ECSResource)PhrancisGame.PhrancisResources.HEALTH);
    private static final ResourceRetriever attack = ResourceRetriever.forResource((ECSResource)PhrancisGame.PhrancisResources.ATTACK);
    private static final ResourceRetriever scrapCost = ResourceRetriever.forResource((ECSResource)PhrancisGame.PhrancisResources.SCRAP_COST);

    public static double attackScore(ECSAction action, ScoreParameters<Entity> params) {
        if (!action.getName().equals("Attack")) {
            return 0.0;
        }
        TargetSet targets = (TargetSet)action.getTargetSets().get(0);
        targets.clearTargets();
        List possibleTargets = targets.findPossibleTargets();
        Optional<Entity> player = possibleTargets.stream().filter(e -> e.hasComponent(PlayerComponent.class)).findAny();
        if (player.isPresent()) {
            targets.addTarget(player.get());
            return 100.0;
        }
        if (possibleTargets.isEmpty()) {
            throw new RuntimeException("Attack action has no targets: " + action);
        }
        possibleTargets.sort(Comparator.comparingInt(e -> AttackAnalyze.attackVS(action.getOwner(), e)));
        Entity chosenTarget = (Entity)possibleTargets.get(possibleTargets.size() - 1);
        targets.addTarget(chosenTarget);
        return AttackAnalyze.attackVS(action.getOwner(), chosenTarget);
    }

    private static int attackVS(Entity attacker, Entity target) {
        int score = 0;
        boolean attackerDies = attack.getFor(target) >= health.getFor(attacker);
        boolean targetDies = attack.getFor(attacker) >= health.getFor(target);
        int trampleDamage = attack.getFor(attacker) - health.getFor(target);
        int additionalDamageBack = attack.getFor(target) - health.getFor(attacker);
        if (attackerDies && !targetDies) {
            return -10;
        }
        if (targetDies) {
            score += 100;
            score -= trampleDamage;
        }
        if (attackerDies) {
            score -= 97;
            score += additionalDamageBack;
        }
        return score;
    }

    public static double scrapNeeded(ECSAction action, ScoreParameters<Entity> params) {
        if (!action.getName().equals("Scrap")) {
            return 0.0;
        }
        Entity entity = action.getOwner();
        ComponentRetriever card = Retrievers.component(CardComponent.class);
        Entity owner = ((CardComponent)card.get(entity)).getOwner();
        HandComponent hand = (HandComponent)owner.getComponent(HandComponent.class);
        return hand.stream().mapToInt(e -> scrapCost.getOrDefault(e, 0)).sum();
    }

    public static double scrapIfCanGetKilled(ECSAction action, ScoreParameters<Entity> params) {
        if (!action.getName().equals("Scrap")) {
            return 0.0;
        }
        Entity entity = action.getOwner();
        ComponentRetriever card = Retrievers.component(CardComponent.class);
        Entity owner = ((CardComponent)card.get(entity)).getOwner();
        Set players = entity.getGame().getEntitiesWithComponent(PlayerComponent.class);
        Entity opponent = players.stream().filter(pl -> ((PlayerComponent)pl.getComponent(PlayerComponent.class)).getIndex() != ((PlayerComponent)owner.getComponent(PlayerComponent.class)).getIndex()).findAny().get();
        ZoneComponent battlefield = (ZoneComponent)opponent.getComponent(BattlefieldComponent.class);
        int myHealth = health.getFor(entity);
        int myAttack = attack.getFor(entity);
        List creaturesCanKill = battlefield.stream().filter(e -> attack.getOrDefault(e, 0) >= myHealth).collect(Collectors.toList());
        if (creaturesCanKill.isEmpty()) {
            return -10.0;
        }
        Stream<Entity> creaturesCanNotDie = creaturesCanKill.stream().filter(e -> health.getOrDefault(e, 0) > myAttack);
        if (creaturesCanNotDie.findAny().isPresent()) {
            return 1.0;
        }
        return 0.25;
    }

    public static double scrapScore(ECSAction action, ScoreParameters<Entity> params) {
        if (!action.getName().equals("Scrap")) {
            return 0.0;
        }
        Entity entity = action.getOwner();
        ComponentRetriever card = Retrievers.component(CardComponent.class);
        ZoneComponent battlefield = ((CardComponent)card.get(entity)).getCurrentZone();
        List creatures = battlefield.getCards();
        if (creatures.size() <= 3) {
            return -health.getFor(entity);
        }
        creatures.sort(Comparator.comparingInt(e -> health.getFor(e) + attack.getFor(e)));
        if (entity == creatures.get(0)) {
            return 4 - health.getFor(entity);
        }
        return -1.0;
    }

    public static double health(ECSAction action, ScoreParameters<Entity> params) {
        return health.getOrDefault(action.getOwner(), 0);
    }

    public static double attack(ECSAction action, ScoreParameters<Entity> params) {
        return attack.getOrDefault(action.getOwner(), 0);
    }

    public static double enchantScore(ECSAction action, ScoreParameters<Entity> params) {
        if (!action.getName().equals("Enchant")) {
            return 0.0;
        }
        TargetSet targets = (TargetSet)action.getTargetSets().get(0);
        targets.clearTargets();
        List possibleTargets = targets.findPossibleTargets();
        if (possibleTargets.isEmpty()) {
            return -1.0;
        }
        Entity enchantment = action.getOwner();
        int attackBonus = attack.getFor(enchantment);
        int healthBonus = health.getFor(enchantment);
        possibleTargets.sort(Comparator.comparingDouble(e -> AttackAnalyze.enchantScore(e, attackBonus, healthBonus)));
        Entity chosenTarget = (Entity)possibleTargets.get(possibleTargets.size() - 1);
        targets.addTarget(chosenTarget);
        return AttackAnalyze.enchantScore(chosenTarget, attackBonus, healthBonus);
    }

    private static double enchantScore(Entity e, int attackBonus, int healthBonus) {
        return 1.5 * (double)(health.getFor(e) + healthBonus) + (double)attack.getFor(e) + (double)attackBonus;
    }
}

