/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.ai;

import com.cardshifter.modapi.actions.ActionComponent;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.ai.CardshifterAI;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.Entity;
import java.util.Collection;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.zomis.aiscores.FieldScoreProducer;
import net.zomis.aiscores.FieldScores;
import net.zomis.aiscores.ScoreConfig;
import net.zomis.aiscores.ScoreConfigFactory;
import net.zomis.aiscores.ScoreParameters;
import net.zomis.aiscores.ScoreStrategy;
import net.zomis.aiscores.extra.ParamAndField;
import net.zomis.aiscores.extra.ScoreUtils;
import net.zomis.cardshifter.ecs.config.ConfigComponent;

public class ScoringAI
implements CardshifterAI,
ScoreStrategy<Entity, ECSAction> {
    private final Random random = new Random(42L);
    private final ScoreConfig<Entity, ECSAction> config;
    private final BiConsumer<Entity, ConfigComponent> entityConfigurer;

    public ScoringAI(ScoreConfigFactory<Entity, ECSAction> config, BiConsumer<Entity, ConfigComponent> configuration) {
        this.config = config.build();
        this.entityConfigurer = configuration;
    }

    public ScoringAI(ScoreConfigFactory<Entity, ECSAction> config) {
        this.config = config.build();
        this.entityConfigurer = (e, comp) -> {};
    }

    public FieldScores<Entity, ECSAction> calculateFullScore(Entity player) {
        FieldScoreProducer prod = new FieldScoreProducer(this.config, (ScoreStrategy)this);
        prod.setDetailed(true);
        return prod.analyzeAndScore((Object)player);
    }

    public ECSAction getAction(Entity player) {
        FieldScoreProducer prod = new FieldScoreProducer(this.config, (ScoreStrategy)this);
        ParamAndField best = ScoreUtils.pickBest((FieldScoreProducer)prod, (Object)player, (Random)this.random);
        if (best != null) {
            return (ECSAction)best.getField();
        }
        return null;
    }

    public boolean canScoreField(ScoreParameters<Entity> params, ECSAction action) {
        return action.isAllowed((Entity)params.getParameters());
    }

    public Collection<ECSAction> getFieldsToScore(Entity entity) {
        return ScoringAI.getAllActions(entity.getGame()).collect(Collectors.toList());
    }

    private static Stream<ECSAction> getAllActions(ECSGame game) {
        return game.getEntitiesWithComponent(ActionComponent.class).stream().flatMap(entity -> ((ActionComponent)entity.getComponent(ActionComponent.class)).getECSActions().stream());
    }

    public void configure(Entity entity, ConfigComponent config) {
        this.entityConfigurer.accept(entity, config);
    }
}

