/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.ai;

import com.cardshifter.ai.phrancis.AttackAnalyze;
import com.cardshifter.api.config.DeckConfig;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.base.Entity;
import net.zomis.aiscores.FScorer;
import net.zomis.aiscores.ScoreConfigFactory;
import net.zomis.aiscores.scorers.PredicateScorer;
import net.zomis.aiscores.scorers.Scorers;
import net.zomis.aiscores.scorers.SimpleScorer;
import net.zomis.cardshifter.ecs.config.ConfigComponent;

public class AIs {
    private static FScorer<Entity, ECSAction> playActionScorer = new PredicateScorer(action -> action.getName().equals("Play"));

    public static ScoreConfigFactory<Entity, ECSAction> loser() {
        ScoreConfigFactory config = new ScoreConfigFactory();
        config.withScorer((FScorer)new PredicateScorer(action -> action.getName().equals("End Turn")));
        return config;
    }

    public static ScoreConfigFactory<Entity, ECSAction> idiot() {
        return new ScoreConfigFactory();
    }

    public static ScoreConfigFactory<Entity, ECSAction> medium() {
        ScoreConfigFactory config = new ScoreConfigFactory();
        config.withScorer((FScorer)new PredicateScorer(action -> action.getName().equals("Use")), -10.0);
        config.withScorer((FScorer)new PredicateScorer(action -> action.getName().equals("Play")), 10.0);
        config.withScorer((FScorer)new PredicateScorer(action -> action.getName().equals("Enchant")), -10.0);
        config.withScorer((FScorer)new SimpleScorer(AttackAnalyze::scrapScore));
        config.withScorer((FScorer)new SimpleScorer(AttackAnalyze::attackScore));
        return config;
    }

    public static ScoreConfigFactory<Entity, ECSAction> fighter() {
        ScoreConfigFactory config = new ScoreConfigFactory();
        config.withScorer(Scorers.multiplication(playActionScorer, (FScorer)new SimpleScorer(AttackAnalyze::health)), 10.0);
        config.withScorer(Scorers.multiplication(playActionScorer, (FScorer)new SimpleScorer(AttackAnalyze::attack)), 2.0);
        config.withScorer((FScorer)new PredicateScorer(action -> action.getName().equals("Use")), -10.0);
        config.withScorer((FScorer)new PredicateScorer(action -> action.getName().equals("Scrap")), -1.0);
        config.withScorer(Scorers.multiplication((FScorer)new SimpleScorer(AttackAnalyze::scrapNeeded), (FScorer)new SimpleScorer(AttackAnalyze::scrapIfCanGetKilled)));
        config.withScorer((FScorer)new SimpleScorer(AttackAnalyze::attackScore));
        config.withScorer((FScorer)new SimpleScorer(AttackAnalyze::enchantScore));
        return config;
    }

    public static void mediumDeck(Entity entity, ConfigComponent config) {
        DeckConfig deck = (DeckConfig)config.getConfig(DeckConfig.class);
        AIs.createDeckFullWith(deck, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
    }

    private static void createDeckFullWith(DeckConfig deck, int ... ids) {
        if (deck == null) {
            return;
        }
        for (int id : ids) {
            if (deck.total() >= deck.getMaxSize()) {
                return;
            }
            deck.setChosen(id, deck.getMaxFor(id));
        }
    }

    public static void fighterDeck(Entity entity, ConfigComponent config) {
        DeckConfig deck = (DeckConfig)config.getConfig(DeckConfig.class);
        AIs.createDeckFullWith(deck, 4, 7, 8, 12, 16, 18, 24, 26, 27);
        AIs.deckAdd(deck, 9, 9, 19);
    }

    private static void deckAdd(DeckConfig deck, int ... ids) {
        if (deck == null) {
            return;
        }
        for (int id : ids) {
            if (deck.total() >= deck.getMaxSize()) {
                return;
            }
            deck.add(id);
        }
    }
}

