/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.api.serial;

import com.cardshifter.api.messages.Message;
import com.cardshifter.api.messages.MessageTypeIdResolver;
import com.cardshifter.api.serial.CommunicationTransformer;
import com.cardshifter.api.serial.FieldsCollection;
import com.cardshifter.api.serial.MessageHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ByteTransformer
implements CommunicationTransformer {
    private static final Logger logger = LogManager.getLogger(ByteTransformer.class);

    public byte[] transform(Message message) throws IOException {
        FieldsCollection<Message> fields = FieldsCollection.gather(message);
        fields = fields.orderByName().putFirst("command");
        return fields.serialize(message);
    }

    @Override
    public void send(Message message, OutputStream out) throws IOException {
        logger.info((Object)("byte send " + message));
        FieldsCollection<Message> fields = FieldsCollection.gather(message);
        fields = fields.orderByName().putFirst("command");
        byte[] b = fields.serialize(message);
        logger.info((Object)("byte send " + Arrays.toString(b)));
        out.write(b);
    }

    @Override
    public void read(InputStream in, MessageHandler onReceived) throws IOException {
        try {
            logger.info((Object)("Started reading " + this));
            Message message = this.readOnce(in);
            logger.info((Object)("byte recieve " + message));
            if (!onReceived.messageReceived(message)) {
                return;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Message readOnce(InputStream in) throws IOException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        DataInputStream data = new DataInputStream(in);
        int numBytes = data.readInt();
        logger.info((Object)("bytes received " + numBytes));
        byte[] actualData = new byte[numBytes];
        for (int read = 0; read < numBytes; read += data.read(actualData, read, numBytes - read)) {
        }
        logger.info((Object)("bytes data received " + Arrays.toString(actualData)));
        data = new DataInputStream(new ByteArrayInputStream(actualData));
        int typeLength = data.readInt();
        String str = this.readString(data, typeLength);
        System.out.println(str);
        Class<?> type = MessageTypeIdResolver.typeFor(str);
        Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        Message message = (Message)constructor.newInstance(new Object[0]);
        FieldsCollection<Message> fields = FieldsCollection.gather(message);
        fields = fields.orderByName().putFirst("command").skipFirst();
        fields.read(message, data);
        return message;
    }

    private String readString(DataInputStream data, int numBytes) throws IOException {
        StringBuilder str = new StringBuilder(numBytes);
        for (int i = 0; i < numBytes; ++i) {
            str.append(data.readChar());
        }
        return str.toString();
    }
}

