/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.api.messages;

import com.cardshifter.api.both.ChatMessage;
import com.cardshifter.api.both.InviteRequest;
import com.cardshifter.api.both.InviteResponse;
import com.cardshifter.api.both.PlayerConfigMessage;
import com.cardshifter.api.incoming.LoginMessage;
import com.cardshifter.api.incoming.RequestTargetsMessage;
import com.cardshifter.api.incoming.ServerQueryMessage;
import com.cardshifter.api.incoming.StartGameRequest;
import com.cardshifter.api.incoming.TransformerMessage;
import com.cardshifter.api.incoming.UseAbilityMessage;
import com.cardshifter.api.messages.Message;
import com.cardshifter.api.outgoing.AvailableModsMessage;
import com.cardshifter.api.outgoing.AvailableTargetsMessage;
import com.cardshifter.api.outgoing.CardInfoMessage;
import com.cardshifter.api.outgoing.ClientDisconnectedMessage;
import com.cardshifter.api.outgoing.EntityRemoveMessage;
import com.cardshifter.api.outgoing.GameMessage;
import com.cardshifter.api.outgoing.GameOverMessage;
import com.cardshifter.api.outgoing.NewGameMessage;
import com.cardshifter.api.outgoing.PlayerMessage;
import com.cardshifter.api.outgoing.ResetAvailableActionsMessage;
import com.cardshifter.api.outgoing.ServerErrorMessage;
import com.cardshifter.api.outgoing.UpdateMessage;
import com.cardshifter.api.outgoing.UsableActionMessage;
import com.cardshifter.api.outgoing.UserStatusMessage;
import com.cardshifter.api.outgoing.WaitMessage;
import com.cardshifter.api.outgoing.WelcomeMessage;
import com.cardshifter.api.outgoing.ZoneChangeMessage;
import com.cardshifter.api.outgoing.ZoneMessage;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.HashMap;
import java.util.Map;

public class MessageTypeIdResolver
implements TypeIdResolver {
    private static final Map<String, Class<? extends Message>> clazzes = new HashMap<String, Class<? extends Message>>();
    private JavaType mBaseType;

    public static Class<?> typeFor(String id) {
        return clazzes.get(id);
    }

    public void init(JavaType baseType) {
        this.mBaseType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromBaseType() {
        throw new AssertionError((Object)"this should never happen");
    }

    public String idFromValueAndType(Object obj, Class<?> clazz) {
        Message mess = (Message)obj;
        return mess.getCommand();
    }

    public JavaType typeFromId(String type) {
        Class<? extends Message> clazz = clazzes.get(type);
        if (clazz == null) {
            throw new UnsupportedOperationException("No such defined type: " + type);
        }
        return TypeFactory.defaultInstance().constructSpecializedType(this.mBaseType, clazz);
    }

    static {
        clazzes.put("serial", TransformerMessage.class);
        clazzes.put("chat", ChatMessage.class);
        clazzes.put("login", LoginMessage.class);
        clazzes.put("startgame", StartGameRequest.class);
        clazzes.put("use", UseAbilityMessage.class);
        clazzes.put("requestTargets", RequestTargetsMessage.class);
        clazzes.put("zoneChange", ZoneChangeMessage.class);
        clazzes.put("entityRemoved", EntityRemoveMessage.class);
        clazzes.put("disconnect", ClientDisconnectedMessage.class);
        clazzes.put("resetActions", ResetAvailableActionsMessage.class);
        clazzes.put("game", GameMessage.class);
        clazzes.put("gameover", GameOverMessage.class);
        clazzes.put("wait", WaitMessage.class);
        clazzes.put("loginresponse", WelcomeMessage.class);
        clazzes.put("newgame", NewGameMessage.class);
        clazzes.put("player", PlayerMessage.class);
        clazzes.put("card", CardInfoMessage.class);
        clazzes.put("zone", ZoneMessage.class);
        clazzes.put("update", UpdateMessage.class);
        clazzes.put("useable", UsableActionMessage.class);
        clazzes.put("targets", AvailableTargetsMessage.class);
        clazzes.put("availableMods", AvailableModsMessage.class);
        clazzes.put("inviteRequest", InviteRequest.class);
        clazzes.put("inviteResponse", InviteResponse.class);
        clazzes.put("error", ServerErrorMessage.class);
        clazzes.put("userstatus", UserStatusMessage.class);
        clazzes.put("query", ServerQueryMessage.class);
        clazzes.put("playerconfig", PlayerConfigMessage.class);
    }
}

