/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.api.config;

import com.cardshifter.api.outgoing.CardInfoMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class DeckConfig {
    private final Map<Integer, CardInfoMessage> cardData;
    private final Map<Integer, Integer> chosen = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> max = new HashMap<Integer, Integer>();
    private final int minSize;
    private final int maxSize;
    private final int maxPerCard;

    DeckConfig() {
        this(0, 0, new HashMap<Integer, CardInfoMessage>(), 0);
    }

    public DeckConfig(int minSize, int maxSize, Map<Integer, CardInfoMessage> cardData, int maxPerCard) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.maxPerCard = maxPerCard;
        this.cardData = new HashMap<Integer, CardInfoMessage>(cardData);
    }

    public void setMax(int id, int max) {
        this.max.put(id, max);
    }

    public void setChosen(int id, int chosen) {
        this.chosen.put(id, chosen);
    }

    public int getChosen(int id) {
        Integer chosen = this.chosen.get(id);
        return chosen == null ? 0 : chosen;
    }

    public void removeChosen(int id) {
        if (this.chosen.get(id) > 1) {
            this.setChosen(id, this.getChosen().get(id) - 1);
        } else {
            this.chosen.remove(id);
        }
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public Map<Integer, CardInfoMessage> getCardData() {
        return Collections.unmodifiableMap(this.cardData);
    }

    public Map<Integer, Integer> getChosen() {
        return Collections.unmodifiableMap(this.chosen);
    }

    public void clearChosen() {
        this.chosen.clear();
    }

    public Map<Integer, Integer> getMax() {
        return new HashMap<Integer, Integer>(this.max);
    }

    public int getMaxPerCard() {
        return this.maxPerCard;
    }

    public int total() {
        int sum = 0;
        for (Integer ee : this.chosen.values()) {
            sum += ee.intValue();
        }
        return sum;
    }

    public String toString() {
        return "DeckConfig [chosen=" + this.chosen + "]";
    }

    public void generateRandom() {
        Random random = new Random();
        ArrayList<Integer> ids = new ArrayList<Integer>(this.getCardData().keySet());
        while (this.total() < this.getMinSize()) {
            int randomId = (Integer)ids.get(random.nextInt(ids.size()));
            this.setChosen(randomId, this.getMaxFor(randomId));
        }
    }

    public void add(int cardId) {
        Integer current = this.chosen.get(cardId);
        if (current == null) {
            current = 0;
        }
        this.chosen.put(cardId, current + 1);
    }

    public int getMaxFor(int id) {
        Integer value = this.max.get(id);
        return value == null ? this.maxPerCard : value;
    }
}

