/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.api.serial;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FieldsCollection<T> {
    private static final Logger logger = LogManager.getLogger(FieldsCollection.class);
    private final List<Field> fields;

    public FieldsCollection(List<Field> fields) {
        this.fields = Collections.unmodifiableList(fields);
    }

    public static <T> FieldsCollection<T> gather(T object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            FieldsCollection.addFields(fields, clazz);
        }
        return new FieldsCollection<T>(fields);
    }

    private static void addFields(List<Field> fields, Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
    }

    public byte[] serialize(T message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            for (Field field : this.fields) {
                this.serialize(field, message, out);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        byte[] data = baos.toByteArray();
        baos = new ByteArrayOutputStream();
        out = new DataOutputStream(baos);
        out.writeInt(data.length);
        baos.write(data);
        return baos.toByteArray();
    }

    private Object deserialize(Class<?> type, DataInputStream data, Field field) throws IOException {
        if (type == Integer.TYPE || type == Integer.class) {
            int value = data.readInt();
            return value;
        }
        if (type == String[].class) {
            int count = data.readInt();
            String[] str = new String[count];
            for (int i = 0; i < str.length; ++i) {
                str[i] = (String)this.deserialize(String.class, data, null);
            }
            return str;
        }
        if (type == int[].class) {
            int count = data.readInt();
            int[] array = new int[count];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Integer)this.deserialize(Integer.class, data, null);
            }
            return array;
        }
        if (type == Boolean.class) {
            byte boolValue = data.readByte();
            Boolean bool = null;
            if (boolValue != 2) {
                bool = boolValue == 1;
            }
            return bool;
        }
        if (type == Boolean.TYPE) {
            byte boolValue = data.readByte();
            return boolValue == 1;
        }
        if (type == String.class) {
            int length = data.readInt();
            StringBuilder str = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                str.append(data.readChar());
            }
            return str.toString();
        }
        if (Enum.class.isAssignableFrom(type)) {
            ?[] values = type.getEnumConstants();
            int ordinal = data.readInt();
            return values[ordinal];
        }
        if (type == Map.class) {
            if (field == null) {
                throw new NullPointerException("Field cannot be null when deserializing Map");
            }
            Type genericFieldType = field.getGenericType();
            if (!(genericFieldType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Cannot deserialize a Map without generics types");
            }
            ParameterizedType aType = (ParameterizedType)genericFieldType;
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            Class keyClass = (Class)fieldArgTypes[0];
            Class valueClass = (Class)fieldArgTypes[1];
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            int size = data.readInt();
            for (int i = 0; i < size; ++i) {
                Object key = this.deserialize(keyClass, data, null);
                Object value = this.deserialize(valueClass, data, null);
                map.put(key, value);
            }
            return map;
        }
        if (type == Object.class) {
            String clazzName = (String)this.deserialize(String.class, data, null);
            try {
                Class<?> clazz = Class.forName(clazzName);
                Object obj = this.deserialize(clazz, data, field);
                logger.debug((Object)("Deserialized object: " + obj));
                return obj;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        logger.info((Object)("Using recursive deserialization for " + type));
        try {
            Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(new Object[0]);
            FieldsCollection<?> fields = FieldsCollection.gather(obj);
            fields = fields.orderByName();
            data.readInt();
            fields.read(obj, data);
            return obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void deserialize(Field field, Object message, DataInputStream data) throws IllegalArgumentException, IllegalAccessException, IOException {
        logger.debug((Object)("read field " + field + " for " + message));
        field.setAccessible(true);
        Class<?> type = field.getType();
        field.set(message, this.deserialize(type, data, field));
    }

    private void serialize(Class<?> type, Object value, DataOutputStream out, Field field) throws IOException, IllegalArgumentException, IllegalAccessException {
        if (type == Integer.TYPE || type == Integer.class) {
            out.writeInt((Integer)value);
        } else if (type == String.class) {
            String str = (String)value;
            out.writeInt(str.length());
            out.writeChars(str);
        } else if (type == Boolean.class) {
            Boolean bool = (Boolean)value;
            int boolValue = bool == null ? 2 : (bool != false ? 1 : 0);
            out.writeByte(boolValue);
        } else if (type == Boolean.TYPE) {
            boolean bool = (Boolean)value;
            int boolValue = bool ? 1 : 0;
            out.writeByte(boolValue);
        } else if (type == String[].class) {
            String[] arr = (String[])value;
            out.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                this.serialize(String.class, arr[i], out, null);
            }
        } else if (type == int[].class) {
            int[] array = (int[])value;
            out.writeInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                this.serialize(Integer.TYPE, array[i], out, null);
            }
        } else if (Enum.class.isAssignableFrom(type)) {
            Enum enumValue = (Enum)value;
            out.writeInt(enumValue.ordinal());
        } else if (type == Map.class) {
            if (field == null) {
                throw new NullPointerException("Field cannot be null when serializing Map");
            }
            Type genericFieldType = field.getGenericType();
            if (!(genericFieldType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Cannot serialize a Map without generics types");
            }
            ParameterizedType aType = (ParameterizedType)genericFieldType;
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            Class keyClass = (Class)fieldArgTypes[0];
            Class valueClass = (Class)fieldArgTypes[1];
            Map map = (Map)value;
            out.writeInt(map.size());
            for (Map.Entry ee : map.entrySet()) {
                this.serialize(keyClass, ee.getKey(), out, null);
                this.serialize(valueClass, ee.getValue(), out, null);
            }
        } else if (type == Object.class) {
            String clazzName = value.getClass().getName();
            this.serialize(String.class, clazzName, out, null);
            this.serialize(value.getClass(), value, out, null);
        } else {
            logger.info((Object)("Using recursive serialization for " + type));
            FieldsCollection<Object> fields = FieldsCollection.gather(value);
            fields = fields.orderByName();
            byte[] b = fields.serialize(value);
            out.write(b);
        }
    }

    private void serialize(Field field, T obj, DataOutputStream out) throws IOException, IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        Class<?> type = field.getType();
        Object value = field.get(obj);
        this.serialize(type, value, out, field);
    }

    public FieldsCollection<T> orderByName() {
        ArrayList<Field> myFields = new ArrayList<Field>(this.fields);
        Collections.sort(myFields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return new FieldsCollection<T>(myFields);
    }

    public FieldsCollection<T> putFirst(String fieldName) {
        ArrayList<Field> myFields = new ArrayList<Field>(this.fields);
        for (Field field : myFields) {
            if (!field.getName().equals(fieldName)) continue;
            myFields.remove(field);
            myFields.add(0, field);
            return new FieldsCollection<T>(myFields);
        }
        throw new IllegalArgumentException("Field name not found: " + fieldName);
    }

    public void read(Object message, DataInputStream data) throws IOException {
        try {
            for (Field field : this.fields) {
                this.deserialize(field, message, data);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public FieldsCollection<T> skipFirst() {
        ArrayList<Field> myFields = new ArrayList<Field>(this.fields);
        myFields.remove(0);
        return new FieldsCollection<T>(myFields);
    }
}

