/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.api;

import com.cardshifter.api.ClientServerInterface;
import com.cardshifter.api.IdObject;
import com.cardshifter.api.messages.Message;
import com.cardshifter.api.outgoing.ServerErrorMessage;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class ClientIO
implements IdObject {
    private static final Logger logger = LogManager.getLogger(ClientIO.class);
    private String name = "";
    private final ClientServerInterface server;
    private int id;

    public ClientIO(ClientServerInterface server) {
        this.server = server;
        this.id = server.newClientId();
    }

    public final void sendToClient(Message message) throws IllegalArgumentException {
        logger.info((Object)("Send to " + this.getName() + ": " + message));
        this.onSendToClient(message);
    }

    protected abstract void onSendToClient(Message var1);

    public abstract String getRemoteAddress();

    public String getName() {
        return this.name;
    }

    public void sentToServer(String message) {
        logger.info((Object)("Incoming message from " + this.name + ": " + message));
        this.server.handleMessage(this, message);
    }

    public void sentToServer(Message message) {
        try {
            this.server.performIncoming(message, this);
        }
        catch (RuntimeException ex) {
            logger.error((Object)("Error performing incoming message from " + this), (Throwable)ex);
            this.sendToClient(new ServerErrorMessage(ex.toString()));
        }
    }

    protected void disconnected() {
        this.server.onDisconnected(this);
    }

    public abstract void close();

    public boolean isLoggedIn() {
        return this.name.length() > 0;
    }

    public String getStatus() {
        return this.isLoggedIn() ? "online" : "offline";
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return this.getId() + ": " + this.getName() + " @ " + this.getRemoteAddress();
    }
}

